
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Auditor Name :  Andro James Sotto
' Audit Date   :  12/31/2017
' Client Name  :  Hemisphere
' Description  :  Please type in a Description.
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

'****************BEGIN HEADER SECTION***************************************************
'***************************************************************************************
On Error Resume Next

Const ForWriting = 2
Const ForReading = 1
Const ForAppending = 8
Const TempFolder = 2
Const HKCR = &H80000000 ' HKEY_CLASSES_ROOT
Const HKCU = &H80000001 ' HKEY_CURRENT_USER
Const HKLM = &H80000002 ' HKEY_LOCAL_MACHINE
Const HKU  = &H80000003 ' HKEY_USERS
Const HKCC = &H80000005 ' HKEY_CURRENT_CONFIG
Const SE_DACL_PRESENT = &h4
Const ACCESS_ALLOWED_ACE_TYPE = &h0
Const ACCESS_DENIED_ACE_TYPE  = &h1
Const FILE_ALL_ACCESS       = &h1f01ff
Const FILE_APPEND_DATA      = &h000004
Const FILE_DELETE           = &h010000
Const FILE_DELETE_CHILD     = &h000040
Const FILE_EXECUTE          = &h000020
Const FILE_READ_ATTRIBUTES  = &h000080
Const FILE_READ_CONTROL     = &h020000
Const FILE_READ_DATA        = &h000001
Const FILE_READ_EA          = &h000008
Const FILE_SYNCHRONIZE      = &h100000
Const FILE_WRITE_ATTRIBUTES = &h000100
Const FILE_WRITE_DAC        = &h040000
Const FILE_WRITE_DATA       = &h000002
Const FILE_WRITE_EA         = &h000010
Const FILE_WRITE_OWNER      = &h080000
Const ADS_SCOPE_SUBTREE     = 2
Const TristateUseDefault    = -2
Dim objShell, objFSO, objFile, objWMIService, objCSV, objUserCSV
Dim strKeyPath, strValueName, RegValue
Dim filesys, Outputfile, txtstream, UserCSV
Dim ScriptUser, ScriptDomain
Dim strComputer: strComputer = "."
Outputfile = "./EY_Windows_Report.txt"

'Vars for writing the HTML file
Dim strOutputFile, strReportFile, strSourceLine
Dim strSourceFile, strSaveDir
Dim WshShl, FsoObj 'changed name to differentiate

Set objShell = WScript.CreateObject ("Wscript.Shell")
Set objCSV = CreateObject("Scripting.FileSystemObject")
Set objFSO = CreateObject("Scripting.FileSystemObject")
Set objExplorer = CreateObject _
    ("InternetExplorer.Application")

objExplorer.Navigate "about:blank"   
objExplorer.ToolBar = 0
objExplorer.StatusBar = 0
objExplorer.Width = 500
objExplorer.Height = 200 
objExplorer.Visible = 1             

objExplorer.Document.Title = "Windows Script Running..." 
objExplorer.Document.Body.InnerHTML = "<b>Script initializing</b> ..."
objExplorer.Document.Body.Style.Cursor = "wait"


CreateOutputFile OutputFile	'Create a plain text output file & write header
wscript.sleep 1000
'****************END HEADER SECTION****************************************************		
'**************************************************************************************

'****BEGIN**** (Test) Default Accounts & Passwords
WriteOutputToFile("****Begin: (Test) Default Accounts & Passwords" & vbcrlf)
Dim defaconsole, arrDefUsers, DefUsers, tmpdefcommand
x=0
Set defaconsole = new cliwrapper
arrDefUsers = Array ( _
   "guest", _
   "helpassistant", _
   "support", _
   "guest /domain", _
   "helpassistant /domain", _
   "support /domain" _
   )
   	
For Each DefUser in arrDefUsers
   Select Case x
      Case 0
         WriteOutputToFile("Guest Local Account Information:")
      Case 1
         WriteOutputToFile("HelpAssistant Local Account Information:")
      Case 2
      	 WriteOutputToFile("Support Local Account Information:")
      Case 3
   	 WriteOutputToFile("Guest Domain Account Information:")
      Case 4
   	 WriteOutputToFile("HelpAssistant Domain Account Information:")   		
      Case 5
      	 WriteOutputToFile("Support Domain Account Information:")
   End Select
   tmpdefcommand = "net user " & arrDefUsers(x)
   arrDefUsers(x) = defaconsole.exec(tmpdefcommand)
   If x > 2 Then
   	Wscript.Sleep 5000 'wait 5s to grab info from the domain
   End If
   If arrDefUsers(x) = "" Then
   	arrDefUsers(x) = "User not found" & vbcrlf
   End If
   WriteOutputToFile(arrDefUsers(x))
   x=x+1
Next

WriteOutputToFile("****End: (Test) Default Accounts & Passwords" & vbcrlf)
'****END**** (Test) Default Accounts & Passwords

'****BEGIN**** Account Lockout
'****BEGIN**** Test Password Policy and Account Lockout 
WriteOutputToFile("****Begin: Test Password Policy and Account Lockout; Account Lockout" & vbcrlf)
Dim tmpAccountOutput, arrAccountOutput
WriteOutputToFile("Account Lockout policy settings:")
WriteoutputTOFile("--------------------------------")
tmpAccountOutput = SeceditCommand("LockoutBadCount")
arrAccountOutput = Split(tmpAccountOutput, "=")
If IsNull(arrAccountOutput(0)) Then
	WriteOutputToFile("LockoutBadCount not found or is not set")
Else
	WriteOutputToFile(arrAccountOutput(0) & arrAccountOutput(1) & " invalid login attempts")
End If

tmpAccountOutput = SeceditCommand("ResetLockoutCount")
arrAccountOutput = Split(tmpAccountOutput, "=")
If IsNull(arrAccountOutput(0)) Then
	WriteOutputToFile("ResetLockoutCount not found or is not set")
Else
	WriteOutputToFile(arrAccountOutput(0) & arrAccountOutput(1) & " minutes")
End If

tmpAccountOutput = SeceditCommand("LockoutDuration")
arrAccountOutput = Split(tmpAccountOutput, "=")
If IsNull(arrAccountOutput(0)) Then
	WriteOutputToFile("LockoutDuration not found or is not set")
Else
	WriteOutputToFile(arrAccountOutput(0) & arrAccountOutput(1) & " minutes")
End If

WriteOutputToFile("****End: Test Password Policy and Account Lockout; Account Lockout" & vbcrlf)
'****END**** Account Lockout
'****END**** Test Password Policy and Account Lockout 

'****BEGIN**** Administration Roles
'****BEGIN**** Group Management
'****BEGIN**** Group Memberships
'****BEGIN**** Powerful Group Membership
'****BEGIN**** Privileged Accounts
'****BEGIN**** Test Access to Data and Data Modification Utilities
'****BEGIN**** Test Access to Privileged IT Functions
'****BEGIN**** Test Granting Advanced User Rights
'****BEGIN**** Test Group Management 
'****BEGIN**** Test Powerful Group Membership

WriteOutputToFile("****Begin: Administration Roles; Group Management; Group Memberships; Test Access to Data and Data Modification Utilities; Test Access to Privileged IT Functions; (Test) Granting Advanced User Rights; (Test) Group Management; (Test) Powerful Group Membership" & vbcrlf)

strComputer = "."
Set colGroups = GetObject("WinNT://" & strComputer & "")
colGroups.Filter = Array("group")
For Each objGroup In colGroups
    WriteOutputToFile("[" & objGroup.Name & "]")
    WriteOutputToFile(vbTab & "(Members)")
    For Each objUser in objGroup.Members
        WriteOutputToFile(vbTab & "   " & objUser.Name)
    Next
    WriteOutputToFile("")
Next

WriteOutputToFile("****End: Administration Roles; Group Management; Group Memberships; Test Access to Data and Data Modification Utilities; Test Access to Privileged IT Functions; (Test) Granting Advanced User Rights; (Test) Group Management; (Test) Powerful Group Membership" & vbcrlf)

'****END**** Administration Roles
'****END**** Group Management
'****END**** Group Memberships
'****END**** Powerful Group Membership
'****END**** Privileged Accounts
'****END**** Test Access to Data and Data Modification Utilities
'****END**** Test Access to Privileged IT Functions
'****END**** Test Granting Advanced User Rights
'****END**** Test Group Management
'****END**** Test Powerful Group Membership

'****BEGIN**** (Test) Domain Structure
WriteOutputToFile("****Begin: (Test) Domain Structure" & vbcrlf)
Set objWMIService = GetObject("winmgmts:\\" & strComputer & "\root\CIMV2")
Set colItems = objWMIService.ExecQuery("SELECT * FROM Win32_ComputerSystem", "WQL")

For Each objItem In colItems
	WriteOutputToFile("Computer Name: " & objItem.Name)
	WriteOutputToFile("Description: " & objItem.Description)
	WriteOutputToFile("Domain: " & objItem.Domain)
	
	Select Case objItem.DomainRole
	   Case 0: WriteOutputToFile("Domain Role: Standalone Workstation")
	   Case 1: WriteOutputToFile("Domain Role: Member Workstation")
	   Case 2: WriteOutputToFile("Domain Role: Standalone Server")
	   Case 3: WriteOutputToFile("Domain Role: Member Server")
	   Case 4: WriteOutputToFile("Domain Role: Backup Domain Controller")
	   Case 5: WriteOutputToFile("Domain Role: Primary Domain Controller")
	End Select
	
	WriteOutputToFile("Part Of Domain: " & objItem.PartOfDomain)
	strRoles = Join(objItem.Roles, ",")
	WriteOutputToFile("Roles: " & strRoles & vbcrlf)
Next

WriteOutputToFile("****End: (Test) Domain Structure" & vbcrlf)
'****END**** (Test) Domain Structure

'****BEGIN**** (Test) Idle Session Time Out
WriteOutputToFile("****Begin: (Test) Idle Session Time Out" & vbcrlf)

RegKey = _
	RegistryRead(HKLM, "System\CurrentControlSet\Services\LanManServer\Parameters", _
        "AutoDisconnect","dword")

If IsNumeric(RegKey) Then
	Select Case RegKey
	   Case "-1"
	   	WriteOutputToFile("Path: HKLM\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters" & _
			"TcpMaxConnectResponseRetransmissions")
	      	WriteOutputToFile("Value: " & RegKey)
	      	WriteOutputToFile("Interpretation: Sessions are never timed out" & vbcrlf)
	   Case Else
	   	WriteOutputToFile("Path: HKLM\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters" & _
			"TcpMaxConnectResponseRetransmissions")
		WriteOutputToFile("Value: " & RegKey & vbcrlf)
		WriteOutputToFile("Interpretation: Inactive sessions are timed out after " &_
			RegKey & " minutes" & vbcrlf)
	End Select
Else
	WriteOutputToFile(RegKey & vbcrlf)
End If
WriteOutputToFile("****End: (Test) Idle Session Time Out" & vbcrlf)
'****END**** (Test) Idle Session Time Out

'****BEGIN**** Test Logical Access Segregation of Duties
WriteOutputToFile("****Begin: Test Logical Access Segregation of Duties" & vbcrlf)

strComputer = "."
Set colGroups = GetObject("WinNT://" & strComputer & "")
colGroups.Filter = Array("group")
For Each objGroup In colGroups
    WriteOutputToFile("[" & objGroup.Name & "]")
    WriteOutputToFile(vbTab & "(Members)")
    For Each objUser in objGroup.Members
        WriteOutputToFile(vbTab & "   " & objUser.Name)
    Next
    WriteOutputToFile("")
Next

WriteOutputToFile("****End: Test Logical Access Segregation of Duties" & vbcrlf)
'****END**** Test Logical Access Segregation of Duties

'****BEGIN**** Test Manage Change Segregation of Duties / Access to Programs

WriteOutputToFile("****Begin: Test Manage Change Segregation of Duties Access to Programs " & vbcrlf)

strComputer = "."
Set colGroups = GetObject("WinNT://" & strComputer & "")
colGroups.Filter = Array("group")
For Each objGroup In colGroups
    WriteOutputToFile("[" & objGroup.Name & "]")
    WriteOutputToFile(vbTab & "(Members)")
    For Each objUser in objGroup.Members
        WriteOutputToFile(vbTab & "   " & objUser.Name)
    Next
    WriteOutputToFile("")
Next

WriteOutputToFile("****End: Test Manage Change Segregation of Duties Access to Programs " & vbcrlf)
'****END**** Test Manage Change Segregation of Duties / Access to Programs 

'****BEGIN**** Test Monitoring of User Access
WriteOutputToFile("****Begin: Test Monitoring of User Access" & vbcrlf)
strComputer = "."
Set objWMIService = GetObject _
    ("winmgmts:\\" & strComputer & "\root\rsop\computer")
Set colItems = objWMIService.ExecQuery("Select * from RSOP_AuditPolicy") 

For Each objItem in colItems  
   	WriteOutputToFile(   "Audit Policy: " & objItem.Category & vbcrlf & _
   			     "Success: " & objItem.Success & vbcrlf & _
   			     "Failure: " & objItem.Failure & vbcrlf)

Next

WriteOutputToFile("****End: Test Monitoring of User Access" & vbcrlf)
'****END**** Test Monitoring of User Access

'****BEGIN**** (Test) Use of NT File System (NTFS)
WriteOutputToFile("****Begin: (Test) Use of NT File System (NTFS)" & vbcrlf)
WriteOutputToFile("Logical Disk Devices found on system:")
WriteOutputToFile("------------------------")
Set objWMIService = GetObject("winmgmts:\\" & strComputer & "\root\CIMV2")
Set colItems = objWMIService.ExecQuery("SELECT * FROM Win32_LogicalDisk")

For Each objItem In colItems
	WriteOutputToFile("Drive: " & objItem.DeviceID)
	Select Case objItem.DriveType
	   Case 0: WriteOutputToFile("Drive Type: Unknown")
	   Case 1: WriteOutputToFile("Drive Type: No root directory")
	   Case 2: WriteOutputToFile("Drive Type: Removable disk")
	   Case 3: WriteOutputToFile("Drive Type: Local disk")
	   Case 4: WriteOutputToFile("Drive Type: Network drive")
	   Case 5: WriteOutputToFile("Drive Type: Compact disk")
	   Case 6: WriteOutputToFile("Drive Type: Ram disk")
	End Select
	WriteOutputToFile("FileSystem: " & objItem.FileSystem & vbcrlf)
Next
WriteOutputToFile("****End: (Test) Use of NT File System (NTFS)" & vbcrlf)
'****END**** (Test) Use of NT File System (NTFS)

'****************BEGIN FOOTER SECTION***************************************************
'***************************************************************************************
objExplorer.Document.Body.InnerHTML = "Creating HTML report ...." 
WriteOutputToFile("Script Completed: " & Now)
CreateHTMLOutput()
objExplorer.Document.Body.Style.Cursor = "default"
objExplorer.Document.Body.InnerHTML = "<b>SCRIPT COMPLETE</b> <br> "& _
		"Plain Text: <br>" & outputfile & "<br><br>" & _
		"HTML: <br>" & strSaveDir & "<br>"
'---------------------------------------------------------------------------------------
'Function: AuditSettingLookup
'Last Modified: 9/20/05 .csm
'This function accepts a string with the audit policy name.  It uses WMI to pull the
'audit policy and it returns an interpretation of the values.
'---------------------------------------------------------------------------------------
Function AuditSettingLookup(strAuditPolicy)
On Error Resume Next
strComputer = "."
Set objWMIService = GetObject _
    ("winmgmts:\\" & strComputer & "\root\rsop\computer")
Set colItems = objWMIService.ExecQuery("Select * from RSOP_AuditPolicy") 

For Each objItem in colItems  
   If objItem.Category = strAuditPolicy Then
   	AuditSettingLookup = "Audit Policy: " & objItem.Category & vbcrlf & _
   			     "Success: " & objItem.Success & vbcrlf & _
   			     "Failure: " & objItem.Failure & vbcrlf
   End If
Next
End Function

'---------------------------------------------------------------------------------------
'Function: Int8ToSec
Function Int8ToSec(ByVal objInt8)
        ' Function to convert Integer8 attributes from
        ' 64-bit numbers to seconds.
        Dim lngHigh, lngLow
        lngHigh = objInt8.HighPart
        ' Account for error in IADsLargeInteger property methods.
        lngLow = objInt8.LowPart
        If lngLow < 0 Then
            lngHigh = lngHigh + 1
        End If
        Int8ToSec = -(lngHigh * (2 ^ 32) + lngLow) / (10000000)
End Function

'---------------------------------------------------------------------------------------
'Function: CheckFileAttrib
'Last Modified: 9/12/05 .csm
'This function accepts a string with the location of a file.  It uses the CIM_DataFile
'class of WMI to return the file attributes.
'---------------------------------------------------------------------------------------
Function CheckFileAttrib(strFileName)
Dim refFile
Set refFile = GetObject("winMgmts:CIM_DataFile.Name='"&strFileName&"'")

With refFile
   If .Archive Then CheckFileAttrib = "Archive;"
   If .Hidden Then CheckFileAttrib = CheckFileAttrib & "Hidden;"
   If .System Then CheckFileAttrib = CheckFileAttrib & "System;"
   If .Compressed Then CheckFileAttrib = CheckFileAttrib & "Compressed with " & _
   	.CompressionMethod & ";"
   If .Readable Then
   	CheckFileAttrib = CheckFileAttrib & "Read;"
   Else
   	CheckFileAttrib = CheckFileAttrib & "Not readable;"
   End If
   If .Writeable Then
   	CheckFileAttrib = CheckFileAttrib & "Write;"
   Else
   	CheckFileAttrib = CheckFileAttrib & "Not writeable;"
   End If
End With
Set refFile = Nothing
End Function

'---------------------------------------------------------------------------------------
'Function: CreateHTMLOutput
'Last Modified: 9/26/05 .csm
'This is the main processing section for the HTML output generation section of thisn
'script.  I call will read the plain text report in, process the data, and write html
'to the HTML report file.  This report file is saved to the current user's desktop
'directory.
'---------------------------------------------------------------------------------------
Function CreateHTMLOutput
strSaveDir = "./EY_Windows_Report.html"

Set WshShl = Wscript.CreateObject("Wscript.Shell")
Set FsoObj = CreateObject("Scripting.FileSystemObject")
Set strSourceFile = FsoObj.OpenTextFile(Outputfile, ForReading, false, TristateUseDefault)
Set strReportFile = FsoObj.CreateTextFile(strSaveDir)
strReportFile.Close
Set strReportFile = FsoObj.OpenTextFile(strSaveDir, ForWriting, false, TristateUseDefault)

WriteHTMLHeader()
'Main loop
Do Until strSourceFile.AtEndofStream
  strSourceline = strSourceFile.ReadLine()
  If Len(strSourceLine) <> 0 Then
    If InStr(1, strSourceLine, "****Begin:") Then
    	WriteToggleStart()
    ElseIf InStr(1, strSourceLine, "****End:") Then
    	WriteToggleEnd()
    Else
    	strReportFile.WriteLine("&nbsp;&nbsp;&nbsp;" & strSourceLine & "<br>")
    End If
  Else
  	strReportFile.WriteLine("<br>")
  End If
  
Loop

strReportFile.Close
strSourceFile.Close
End Function


'---------------------------------------------------------------------------------------
'Function: CreateOutputFile
'Last Modified: 10/11/05 .csm
'This function writes the output file for the script.  The name and destination of the
'file is passed in as string variable. Uses Wscript.network to find current user id
'and domain, tries Win32_ComputerSystem and prompts if both of these methods fail.
'---------------------------------------------------------------------------------------
Function CreateOutputFile(OutputFile)
Dim tmpCurrentUser, objNetwork
strComputer = "."
'get local user information and add to the header file
Set objNetwork = CreateObject("Wscript.Network")
Set objWMIService = GetObject("winmgmts:\\" & strComputer & "\root\CIMV2")
Set colItems = objWMIService.ExecQuery("SELECT * FROM Win32_ComputerSystem")
For Each objItem In colItems
	tmpCurrentUser = objItem.UserName
Next

If IsNull(tmpCurrentUser) Then
   	ScriptDomain = objNetwork.UserDomain
	ScriptUser = objNetwork.UserName
	If ISNull(ScriptDomain) or IsNull(ScriptUser) Then ' have user manually enter information as a last resort
		ScriptDomain = InputBox("Please enter the current domain:")
		ScriptUser = InputBox("Please enter the current user ID:")
	End if
Else
	tmpCurrentUser = Split(tmpCurrentUser,"\")
	ScriptDomain = tmpCurrentUser(0)
	ScriptUser = tmpCurrentUser(1)
End if

Set objFile = objFSO.CreateTextFile(Outputfile) 'Create the File
objFile.Close
'Re-open file, write the headcer & 1st line of output
Set objFile = objFSO.OpenTextFile(Outputfile, ForWriting, true, TristateUseDefault)
objFile.WriteLine "EY Script Output File"
objFile.WriteLine "Created: " & Now
objFile.WriteLine "Computer Domain: " & ScriptDomain
objFile.WriteLine "Current User: " & ScriptUser & vbcrlf
objFile.Close
End Function 

'---------------------------------------------------------------------------------------
'Function: DumpSecCommand
'Last Modified: 11/09/05 .csm
'This function will accept a command and a search value for DumpSec.  The function will
'run the command using the WSH run object.  It will save the file, open it, search for
'the value and output the line to the text output file.
'---------------------------------------------------------------------------------------
Function DumpSecCommand(strDumpSecCommand, strLookFor)
Dim strDumpSecPath, wsh
Dim objDumpFile, strReportLine
Dim intLineCount: intLineCount = 0
strDumpSecPath = "DUMPSEC.exe"

If strDumpSecCommand = "rights" Then
   	strDumpSecCommand = " /rpt=rights /outfile=C:\tmpdump.dcl /saveas=fixed"
End If

' only run the command if DumpSec exists
If objFSO.FileExists(strDumpSecPath) Then
   'run command if DumpSec found
   Set wsh = CreateObject("WScript.Shell")
   wsh.run Chr(34) & strDumpSecPath & Chr(34) & strDumpSecCommand, 0, true
Else
   WriteOutputToFile("DumpSec.exe was not found in current directory.")
End If  

If objFSO.FileExists("C:\tmpdump.dcl") Then
   Set objDumpFile = objFSO.OpenTextFile("C:\tmpdump.dcl", ForReading, false, TristateUseDefault)
   Do While objDumpFile.AtEndofStream <> true
      strReportLine = objDumpFile.ReadLine()
	   If Len(strReportLine) <> 0 Then
	      If UCase(strLookFor) = "ALL" Then
	         WriteOutputToFile(strReportLine)
	         LineCount=LineCount+1
	      ElseIf InStr(1, strReportLine, strLookFor) Then
	         WriteOutputToFile(strReportLine)
	         LineCount=LineCount+1
	      End If
	   End If
   Loop
   
   If LineCount=0 Then 'if it cannot find the right in the report
   	WriteOutputToFile(strLookFor & " - was not found or is not specified.")
   End If
   
   objDumpFile.Close
   objFSO.DeleteFile("C:\tmpdump.dcl")
End If 
End Function

'---------------------------------------------------------------------------------------
'Function: FileDACLLookup
'Last Modified: 9/15/05 .csm
'This function will accept a file name (or folder) and will look at the ACL and return 
'ACEs for all trustees (users) with access. The output is written and returned in an 
'array to reduce file I/O.  It uses the WMI Win32_LogicalFileSecuritySettings class
'---------------------------------------------------------------------------------------
Function FileDACLLookup(strFileName)
'Array is used to return the output
On Error Resume Next 
Dim daclLine: daclLine = 0
Dim objFileSecuritySettings
Dim intRetVal, intControlFlags
ReDim arrResult(0) ' reset the array
Set objWMIService = GetObject("winmgmts:")
Set objFileSecuritySettings = objWMIService.Get("Win32_LogicalFileSecuritySetting='" & strFileName & "'")
intRetVal = objFileSecuritySettings.GetSecurityDescriptor(objSD)

intControlFlags = objSD.ControlFlags

If intControlFlags AND SE_DACL_PRESENT Then
   arrACEs = objSD.DACL
   For Each objACE in arrACEs
      ReDim Preserve arrResult(daclLine) ' resize the array
      arrResult(daclLine) = objACE.Trustee.Domain & "\" & objACE.Trustee.Name 'write output to array
      daclLine = daclLine+1 ' increment index
      If objACE.AceType = ACCESS_ALLOWED_ACE_TYPE Then
         ReDim Preserve arrResult(daclLine)
         arrResult(daclLine) = vbtab & "Allowed:"
         daclLine=daclLine+1
      ElseIf objACE.AceType = ACCESS_DENIED_ACE_TYPE Then
         ReDim Preserve arrResult(daclLine)
         arrResult(daclLine) = vbTab & "Denied:"
         daclLine=daclLine+1
      End If
      If objACE.AccessMask AND FILE_ALL_ACCESS Then
         ReDim Preserve arrResult(daclLine)
         arrResult(daclLine) = vbTab & vbTab & "FILE_ALL_ACCESS"
         daclLine=daclLine+1
      End If
      If objACE.AccessMask AND FILE_APPEND_DATA Then
         ReDim Preserve arrResult(daclLine)
         arrResult(daclLine) = vbTab & vbTab & "FILE_APPEND_DATA"
         daclLine=daclLine+1
      End If
      If objACE.AccessMask AND FILE_DELETE Then
         ReDim Preserve arrResult(daclLine)
         arrResult(daclLine) = vbTab & vbTab & "FILE_DELETE"
         daclLine=daclLine+1
      End If
      If objACE.AccessMask AND FILE_DELETE_CHILD Then
         ReDim Preserve arrResult(daclLine)
         arrResult(daclLine) = vbTab & vbTab & "FILE_DELETE_CHILD"
         daclLine=daclLine+1
      End If
      If objACE.AccessMask AND FILE_EXECUTE Then
         ReDim Preserve arrResult(daclLine)
         arrResult(daclLine) = vbTab & vbTab & "FILE_EXECUTE"
         daclLine=daclLine+1
      End If
      If objACE.AccessMask AND FILE_READ_ATTRIBUTES Then
         ReDim Preserve arrResult(daclLine)
         arrResult(daclLine) = vbTab & vbTab & "FILE_READ_ATTRIBUTES"
         daclLine=daclLine+1
      End If
      If objACE.AccessMask AND FILE_READ_CONTROL Then
         ReDim Preserve arrResult(daclLine)
         arrResult(daclLine) = vbTab & vbTab & "FILE_READ_CONTROL"
         daclLine=daclLine+1
      End If
      If objACE.AccessMask AND FILE_READ_DATA Then
         ReDim Preserve arrResult(daclLine)
         arrResult(daclLine) = vbTab & vbTab & "FILE_READ_DATA"
         daclLine=daclLine+1
      End If
      If objACE.AccessMask AND FILE_READ_EA Then
         ReDim Preserve arrResult(daclLine)
         arrResult(daclLine) = vbTab & vbTab & "FILE_READ_EA"
         daclLine=daclLine+1
      End If
      If objACE.AccessMask AND FILE_SYNCHRONIZE Then
         ReDim Preserve arrResult(daclLine)
         arrResult(daclLine) = vbTab & vbTab & "FILE_SYNCHRONIZE"
         daclLine=daclLine+1
      End If
      If objACE.AccessMask AND FILE_WRITE_ATTRIBUTES Then
         ReDim Preserve arrResult(daclLine)
         arrResult(daclLine) = vbTab & vbTab & "FILE_WRITE_ATTRIBUTES"
         daclLine=daclLine+1
      End If
      If objACE.AccessMask AND FILE_WRITE_DAC Then
         ReDim Preserve arrResult(daclLine)
         arrResult(daclLine) = vbTab & vbTab & "FILE_WRITE_DAC"
         daclLine=daclLine+1
      End If
      If objACE.AccessMask AND FILE_WRITE_DATA Then
         ReDim Preserve arrResult(daclLine)
         arrResult(daclLine) = vbTab & vbTab & "FILE_WRITE_DATA"
         daclLine=daclLine+1
      End If
      If objACE.AccessMask AND FILE_WRITE_EA Then
         ReDim Preserve arrResult(daclLine)
         arrResult(daclLine) = vbTab & vbTab & "FILE_WRITE_EA"
         daclLine=daclLine+1
      End If
      If objACE.AccessMask AND FILE_WRITE_OWNER Then
         ReDim Preserve arrResult(daclLine)
         arrResult(daclLine) = vbTab & vbTab & "FILE_WRITE_OWNER"
         daclLine=daclLine+1
      End If
      If objACE.AccessMask AND FOLDER_ADD_SUBDIRECTORY Then
         ReDim Preserve arrResult(daclLine)
         arrResult(daclLine) = vbTab & vbTab & "FOLDER_ADD_SUBDIRECTORY"
         daclLine=daclLine+1
      End If
      If objACE.AccessMask AND FOLDER_TRAVERSE Then
         ReDim Preserve arrResult(daclLine)
         arrResult(daclLine) = vbTab & vbTab & "FOLDER_TRAVERSE"
         daclLine=daclLine+1
      End If      
      If objACE.AccessMask AND FOLDER_LIST_DIRECTORY Then
         ReDim Preserve arrResult(daclLine)
         arrResult(daclLine) = vbTab & vbTab & "FOLDER_LIST_DIRECTORY"
         daclLine=daclLine+1
      End If  
      If objACE.AccessMask AND FOLDER_ADD_FILE Then
         ReDim Preserve arrResult(daclLine)
         arrResult(daclLine) = vbTab & vbTab & "FOLDER_ADD_FILE"
         daclLine=daclLine+1
      End If     
      ReDim Preserve arrResult(daclLine)       
      arrResult(daclLine) = ""
      daclLine=daclLine+1
   Next
Else
   arrResult(dacline) = "No DACL present in security descriptor or file/folder not found" & _
   	" for: " & strFileName
End If
FileDACLLookup = arrResult
End Function

'---------------------------------------------------------------------------------------
'Function: FilePermissionLookup
'Last Modified: 9/7/05 .csm
'This function will look at the ACL/ACE and return the users/groups who have access
'and their specific permissions.  Uses the "cacls" command
'---------------------------------------------------------------------------------------
Function FilePermissionLookup(FileLocation)
Dim fpCommand
Dim console
Set console = new cliwrapper
fpCommand = "CACLS " & FileLocation & " /t /c"
FilePermissionLookup = console.exec(fpcommand)
End Function

'---------------------------------------------------------------------------------------
'Function: GetDCList
'Last Modified: 10/13/05 .csm
'This function performs an LDAP query and returns an array of all DCs found.
'---------------------------------------------------------------------------------------
Function GetDCList
' Determine configuration context and DNS domain from RootDSE object.
Set objRootDSE1 = GetObject("LDAP://RootDSE")
strConfig1 = objRootDSE1.Get("configurationNamingContext")
strDNSDomain1 = objRootDSE1.Get("defaultNamingContext")

' Use ADO to search Active Directory for ObjectClass nTDSDSA.
' This will identify all Domain Controllers.
Set objcmd = CreateObject("ADODB.Command")
Set objconn = CreateObject("ADODB.Connection")
objconn.Provider = "ADsDSOObject"
objconn.Open "Active Directory Provider"
objcmd.ActiveConnection = objconn

strBase = "<LDAP://" & strConfig1 & ">"
strFilter = "(objectClass=nTDSDSA)"
strAttributes = "AdsPath"
strQuery = strBase & ";" & strFilter & ";" & strAttributes & ";subtree"

objcmd.CommandText = strQuery
objcmd.Properties("Page Size") = 100
objcmd.Properties("Timeout") = 60
objcmd.Properties("Cache Results") = False

Set objRecordSetLast = objcmd.Execute

' Enumerate parent objects of class nTDSDSA. Save Domain Controller
' AdsPaths in dynamic array arrstrDCs.
k = 0
Do Until objRecordSetLast.EOF
  Set objDC = _
    GetObject(GetObject(objRecordSetLast.Fields("AdsPath")).Parent)
  ReDim Preserve arrstrDCs(k)
  arrstrDCs(k) = objDC.DNSHostName
  k = k + 1
  objRecordSetLast.MoveNext
Loop

GetDCList = arrstrDCs
End Function

'---------------------------------------------------------------------------------------
'Function: GetLastLogon
'Last Modified: 10/13/05 .csm
'This function accepts a list of DCs in an array and a user account.  It will query
'LDAP on each DC to find the user's 'lastlogon' attribute value.  The script finds the
'newest lastlogon time and returns the number of days since this logon.
'---------------------------------------------------------------------------------------
Function GetLastLogon(arrDClist, strUserAccountName)
Dim objRecordSetLast, objDate
Set objRootDSE = GetObject("LDAP://RootDSE")
strConfig = objRootDSE.Get("configurationNamingContext")
strDNSDomain = objRootDSE.Get("defaultNamingContext")
Set objcmd = CreateObject("ADODB.Command")
Set objConn = CreateObject("ADODB.Connection")
objConn.Provider = "ADsDSOObject"
objConn.Open "Active Directory Provider"
objcmd.ActiveConnection = objConn

objcmd.Properties("Page Size") = 100
objcmd.Properties("Timeout") = 60
objcmd.Properties("Cache Results") = False

Dim tmpLastLogonDate: tmplastLogonDate = #1/1/1601#

For k = 0 To Ubound(arrDClist)
  strBase = "<LDAP://" & arrDClist(k) & "/" & strDNSDomain & ">"
  strFilter = "(&(objectCategory=person)(objectClass=user) (sAMAccountName=" & strUserAccountName & _
  		"))"
  strAttributes = "lastLogon"
  strQuery = strBase & ";" & strFilter & ";" & strAttributes _
    & ";subtree"
  objcmd.CommandText = strQuery
  On Error Resume Next
  Set objRecordSetLast= objcmd.Execute
  If Err.Number <> 0 Then
    On Error Resume Next
    'Wscript.Echo "Domain Controller not available: " & arrstrDCs(k)
    WriteOutputToFile("user not found in " & arrDClist(k))
  Else
   On Error Resume Next
    Do Until objRecordSetLast.EOF
      lngDate = objRecordSetLast.Fields("lastLogon")
      On Error Resume Next
      'Set objDate = lngDate
      
      If Err.Number <> 0 Then
        On Error Resume Next
        lngdate = 0
      End If
   
      If Integer8Date(lngdate) > tmpLastLogonDate Then ' if the current login date is the biggest
      	tmpLastLogonDate = Integer8Date(lngdate)
      End If
      objRecordSetLast.MoveNext
    Loop
  End If

Next

If CStr(tmpLastLogonDate) = "1/1/1601" Then
	GetLastLogon = "Unknown or Never"
Else
	GetLastLogon = CStr(Int(Now - tmpLastLogonDate))
End If
End Function

'---------------------------------------------------------------------------------------
'Function: GetLastLogonStamp
'Last Modified: 10/13/05 .csm
'This function uses the Active Directory 2003 schema attribute 'lastlogontimestamp' to
'pull the information on the last logon date.  It returns the number of days that the
'user last logged into the system.  Since this attribute is only replicated every 14
'days, users are warned to expect a 14 day variance in the output.
'---------------------------------------------------------------------------------------
Function GetLastLogonStamp(strUserAccountName)
Dim objRecordSetLast
Set objRootDSE = GetObject("LDAP://RootDSE")
strConfig = objRootDSE.Get("configurationNamingContext")
strDNSDomain = objRootDSE.Get("defaultNamingContext")
Set objcmd = CreateObject("ADODB.Command")
Set objConn = CreateObject("ADODB.Connection")
objConn.Provider = "ADsDSOObject"
objConn.Open "Active Directory Provider"
objcmd.ActiveConnection = objConn

objcmd.Properties("Page Size") = 100
objcmd.Properties("Timeout") = 60
objcmd.Properties("Cache Results") = False

objCmd.CommandText = strQuery

strBase = "<LDAP://" & strDNSDomain & ">"
strFilter = "(&(objectCategory=person)(objectClass=user) (sAMAccountName=" & strUserAccountName & _
  		"))"
strAttributes = "lastlogontimestamp"
strQuery = strBase & ";" & strFilter & ";" & strAttributes _
    & ";subtree"
 
objCmd.CommandText = strQuery
On Error Resume Next
Set objRecordSetLast = objCmd.Execute
If Err.Number <> 0 Then
    On Error GoTo 0
    GetLastLogonStamp = "Error"
Else
   On Error Resume Next
    Do Until objRecordSetLast.EOF
      lngDate = objRecordSetLast.Fields("lastLogontimestamp")
      objRecordSetLast.MoveNext
    Loop
End If
If IsNull(lngdate)  Then
Else
   If CStr(Integer8Date(lngdate)) = "1/1/1601" Then
	GetLastLogonStamp = "Unknown"
   Else
	GetLastLogonStamp = Int(Now - Integer8Date(lngdate))
   End If
End If		
End Function

'---------------------------------------------------------------------------------------
'Function: GetPath
'Last Modified: 9/15/05 .csm
'This function will return the path from environment constant dirs.
'---------------------------------------------------------------------------------------
Function GetPath(strFolder)
Dim wshShell, wshFSO, tmpRootString
'Valid names for Wscript.Shell
	'AllUsersDesktop 
	'AllUsersStartMenu 
	'AllUsersPrograms 
	'AllUsersStartup 
	'Desktop 
	'Favorites 
	'Fonts 
	'MyDocuments 
	'NetHood	 
	'PrintHood 
	'Programs 
	'Recent 
	'SendTo 
	'StartMenu 
	'Startup 
	'Templates 

Select Case strFolder
   Case "windows"
   	Set wshFSO = CreateObject("Scripting.FileSystemObject")
   	GetPath = wshFSO.GetSpecialFolder(0) ' 0 = Windows Folder
   Case "system"
   	Set wshFSO = CreateObject("Scripting.FileSystemObject")
   	GetPath = wshFSO.GetSpecialFolder(1) ' 1 = System Folder
   Case "temp"
   	Set wshFSO = CreateObject("Scripting.FileSystemObject")
   	GetPath = wshFSO.GetSpecialFolder(2) ' 2 = Temporary Folder
   Case "root"
   	Set wshFSO = CreateObject("Scripting.FileSystemObject")
   	tmpRootString = wshFSO.GetSpecialFolder(0)
   	tmpRootString = Left(tmpRootString,1)
   	GetPath = tmpRootString & ":\" 
   Case Else
   	Set wshShell = CreateObject("Wscript.shell")
   	GetPath = wshShell.SpecialFolders(strFolder)
   If Err Then
	GetPath = "Error - call contains string that is not recognized by Wscript.shell"
   End If
End Select

End Function


'---------------------------------------------------------------------------------------
'Function: Integer8Date
'Last Modified: 9/28/05 .csm
'This function accepts a date (in Integer8 format) and outputs it to date format
'adjusted to consider local time zone bias
'Source = rmeuller.net
'---------------------------------------------------------------------------------------
Function Integer8Date(objDate)
' Obtain local time zone bias from machine registry.
Set objShell = CreateObject("Wscript.Shell")
lngBiasKey = objShell.RegRead("HKLM\System\CurrentControlSet\Control\" _
  & "TimeZoneInformation\ActiveTimeBias")
If UCase(TypeName(lngBiasKey)) = "LONG" Then
  lngBias = lngBiasKey
ElseIf UCase(TypeName(lngBiasKey)) = "VARIANT()" Then
  lngBias = 0
  For k = 0 To UBound(lngBiasKey)
    lngBias = lngBias + (lngBiasKey(k) * 256^k)
  Next
End If
'Do the conversion
Dim lngAdjust, lngDate, lngHigh, lngLow
lngAdjust = lngBias
lngHigh = objDate.HighPart
lngLow = objdate.LowPart
' Account for bug in IADslargeInteger property methods.
If lngLow < 0 Then
	lngHigh = lngHigh + 1
End If
If (lngHigh = 0) And (lngLow = 0) Then
	lngAdjust = 0
End If
lngDate = #1/1/1601# + (((lngHigh * (2 ^ 32)) _
	+ lngLow) / 600000000 - lngAdjust) / 1440
Integer8Date = CDate(lngDate)
End Function


'---------------------------------------------------------------------------------------
'Function: RegistryLookup
'Last Modified: 9/19/05 .csm
'This function accepts a string (RegKey) that is the path of a registry key, and an 
'array that contains the interpretation of the key's values. It uses WSH to read the
'registry value, then it returns the interpretation of the value as a string.
'---------------------------------------------------------------------------------------
Function RegistryLookup(RegKey,RegArray)
Dim tmpKeyName: tmpKeyName = RegKey
'checks to see if the value exists
On Error Resume Next
RegKey = objShell.RegRead(RegKey)
If Err.Number <> 0 Then
       RegistryLookup = "Error: '" & tmpKeyName & "' not found in registry." & vbcrlf
End if
On Error Goto 0
'Interpret and write output to string
For x=lbound(RegArray) to ubound(RegArray)
   If cstr(RegKey)=RegArray(x,0) then
        RegistryLookup = "Path: " & tmpKeyName & vbcrlf & _
        	"Value: " & RegArray(x,0) & vbcrlf & _
        	"Interpretation: " & RegArray(x,1)	
   End if
Next
End Function

'---------------------------------------------------------------------------------------
'Function: RegistryRead
'Last Modified: 9/20/05 .csm
'This function accepts a string (strRegKey), reads the value, and returns the value.
'RegistryRead works for string & character based registry values only.
'---------------------------------------------------------------------------------------
Function RegistryRead(RegHive, RegKeyPath, RegKeyValueName,RegType)
Dim tmpRegValue
strComputer = "."
 
Set oReg=GetObject("winmgmts:{impersonationLevel=impersonate}!\\" & _ 
	strComputer & "\root\default:StdRegProv")

Select Case RegType
   Case "binary"
	oReg.GetBinaryValue RegHive,regKeyPath,RegKeyValueName,tmpRegValue
	RegistryRead = tmpRegValue
   
   Case "dword"
	oReg.GetDWORDValue RegHive,regKeyPath,RegKeyValueName,tmpRegValue
	RegistryRead = tmpRegValue

   Case "expandedstring"
   	oReg.GetExpandedStringValue RegHive,regKeyPath,RegKeyValueName,tmpRegValue
   	RegistryRead = tmpRegValue
   	
   Case "multistring"
   	oReg.GetMultiStringValue RegHive,regKeyPath,RegKeyValueName,tmpRegValue
   	RegistryRead = tmpRegValue
   
   Case "string"
   	oReg.GetStringValue RegHive,regKeyPath,RegKeyValueName,tmpRegValue
   	RegistryRead = tmpRegValue
   
   Case Else
   	RegistryRead = "Parameter: '" & RegHive & "' is not valid for the RegRead function"
   	
End Select

If IsNull(RegistryRead) Then
	RegistryRead = "Registry value '" & RegKeyValueName & "' not found in registry."
End If

If Err.Number <> 0 Then
       RegistryRead = "'" & ReKeyValueName & "' not found in registry." & vbcrlf
End If	

End Function


'---------------------------------------------------------------------------------------
'Function: RtnOutputStr
'Last Modified: 1/26/07 .csm
'Parses XML for MBSA and handles nulls and blank field values.
'---------------------------------------------------------------------------------------
'if XML field doesn't exist, return strMT
'if field exists And empty, return strMT
'if field populated, return strPrefix & Executed strIn & strSuffix
Function RtnOutputStr(strPrefix, strIn, strSuffix, strMT)

Dim strWk, intErrNum
On Error Resume Next
 Execute "strWk = " & strIn : intErrNum = Err.Number : Err.Clear
On Error Goto 0

If intErrNum <> 0 Then strWk = ""

If strWk = "" Or IsNull(strWk) Then
 RtnOutputStr = strMT : Exit Function
Else
 RtnOutputStr = strPrefix & strWk & strSuffix
End If

End Function


'---------------------------------------------------------------------------------------
'Function: SeceditAudit
'Last Modified: 10/4/05 .csm
'This function will accept a string containing the name of an auditing policy,
'call SeceditCommand to create a merged policy, read the policy, and interpret the
'numerical meaning of the setting and return it as a string.
'---------------------------------------------------------------------------------------
Function SeceditAudit(strLookupAudit)
Dim arrLookupAudit
strLookupAudit = SeceditCommand(strLookupAudit) 'get the value
arrLookupAudit = Split(strLookupAudit, "=") ' parse
If IsNumeric(Trim(arrLookupAudit(1))) Then
	If IsNull(arrLookupAudit(0)) Then
	   SeceditAudit = arrLookupAudit(0) & " not found or is not set"
	ElseIF arrLookupAudit(0) = "" Then
	   SeceditAudit = arrLookupAudit(0) & " not found or is not set"
	Else
	   Select Case Trim(arrLookupAudit(1))
		Case "0"
			SeceditAudit = arrLookupAudit(0) & " is set for no auditing"
		Case "1"
			SeceditAudit = arrLookupAudit(0) & " is set to audit successes"
		Case "2"
			SeceditAudit = arrLookupAudit(0) & " is set to audit failures"
		Case "3"
			SeceditAudit = arrLookupAudit(0) & " is set to audit successes & failures"
	   End Select
	End If
Else
	SeceditAudit = strLookupAudit
End If
End Function

'---------------------------------------------------------------------------------------
'Function: SeceditCommand
'Last Modified: 10/3/05 .csm
'This function will generate a merged policy (similar to RSOP) using Secedit.  The
'function will accept a search variable which it will look for in the merged policy
'output file.  If it finds a line that contains the variable it will return that line
'as a string.
'---------------------------------------------------------------------------------------
Function SeceditCommand(strSearchFor)
Dim wshSec
Dim objSecFile, strCurrentLine
Dim intLineNum: intLineNum = 0

Set wshSec = CreateObject("WScript.Shell")
wshSec.run "secedit /export /mergedpolicy /cfg C:\secdump.txt /quiet", 0, true

If objFSO.FileExists("C:\secdump.txt") Then
   Set objSecFile = objFSO.OpenTextFile("C:\secdump.txt", ForReading, false, TristateUseDefault) 
   Do While objSecFile.AtEndofStream <> true
      strCurrentLine = objSecFile.ReadLine()
      If InStr(1, strCurrentLine, strSearchFor) Then
          SeceditCommand = strCurrentLine
	  intLineNum=intLineNum+1
      End If   
   Loop
   
   objSecFile.Close
   objFSO.DeleteFile("C:\secdump.txt")
End If 
End Function

'---------------------------------------------------------------------------------------
'Function: ServiceLookup
'Last Modified: 9/14/05 .csm
'This function accepts a string (strServiceDispName) that is the display name of the
'service.  It uses WMI to return information about that service on the local machine.
'---------------------------------------------------------------------------------------
Function ServiceLookup(strServiceDispName)
Dim cInstances, oInstance
sComputer = "."
Set cInstances = GetObject("winmgmts:{impersonationLevel=impersonate}//" &_ 
	sComputer & "/root/cimv2:Win32_Service").Instances_

For Each oInstance In cInstances
  If oinstance.Properties_("DisplayName").Value = strServiceDispName Then
  	ServiceLookup = _
  	   "Name:" & vbTab & vbTab & oInstance.Properties_("Name").Value & _
  	   vbcrlf& "DisplayName:" & vbTab & oInstance.Properties_("DisplayName").Value & _
  	   vbcrlf& "StartMode:" & vbTab & oInstance.Properties_("StartMode").Value & _
  	   vbcrlf& "State:" & vbTab & vbTab & oInstance.Properties_("State").Value & _
  	   vbcrlf& "Status:" & vbTab & vbTab & oInstance.Properties_("Status").value
   End If
Next
End Function

'---------------------------------------------------------------------------------------
'Function: WriteHTMLHeader
'Last Modified: 9/26/05 .csm
'This function writes the html header & script information
'---------------------------------------------------------------------------------------
Function WriteHTMLHeader
strReportFile.writeline("<head>")
strReportFile.writeline("<title>Windows Script Output</title>")
strReportFile.writeline("<script>")
strReportFile.writeline("function toggle(toggleId, e)")
strReportFile.writeline("{")
strReportFile.writeline(" if (!e) {")
strReportFile.writeline("  e = window.event;")
strReportFile.writeline(" }")
strReportFile.writeline(" if (!document.getElementById) {")
strReportFile.writeline("  return false;")
strReportFile.writeline(" }")
strReportFile.writeline(" var body = document.getElementById(toggleId);")
strReportFile.writeline(" if (!body) {")
strReportFile.writeline("  return false;")
strReportFile.writeline(" }")
strReportFile.writeline(" var im = toggleId + " &Chr(34)&"_toggle"&Chr(34)&";")
strReportFile.writeline(" if (body.style.display == 'none') { ")
strReportFile.writeline("  body.style.display = 'block'; ")
strReportFile.writeline(" } else { ")
strReportFile.writeline("  body.style.display = 'none'; ")
strReportFile.writeline(" } ")
strReportFile.writeline(" if (e) { ")
strReportFile.writeline("  e.cancelBubble = true; ")
strReportFile.writeline("  if (e.stopPropagation) { ")
strReportFile.writeline("   e.stopPropagation(); ")
strReportFile.writeline("  } ")
strReportFile.writeline(" } ")
strReportFile.writeline("} ")
strReportFile.writeline("</script> ")
strReportFile.writeline("</head> ")
strSourceline = strSourceFile.ReadLine()
strReportFile.WriteLine("<h2>" & strSourceLine & "</h2>")
End Function

'---------------------------------------------------------------------------------------
'Function: WriteOutputToCSV
'Last Modified: 10/14/05 .csm
'This function accepts a string and writes it to the output file
'---------------------------------------------------------------------------------------
Function WriteOutputToCSV(strCSVOutput)
'Check if file exists & write the data
On Error Resume Next

Set objUserCSV = objCSV.OpenTextFile(UserCSV, ForAppending)

If objCSV.FileExists(UserCSV) Then
   If CStr(strCSVOutput) = "*newline*" Then
   	objuserCSV.Write vbcrlf
   Else
	If CStr(InStr(1,strCSVOutput, ",")) Then
		strCSVOutput = Chr(34) & strCSVOutput & Chr(34)
	ElseIf CStr(Trim(strCSVOutput)) = "" Then
		strCSVOutput = " " 
	End If 	
	objUserCSV.Write strCSVOutput & ","
   End If
Else	
	' file DNE
End If

objUserCSV.Close
End Function

'---------------------------------------------------------------------------------------
'Function: WriteOutputToFile
'Last Modified: 9/28/05 .csm
'This function accepts a string and writes it to the output file
'---------------------------------------------------------------------------------------
Function WriteOutputToFile(strOutput)
'Check if file exists & write the data
On Error Resume Next
'Wscript.echo (strOutput)

If objFSO.FileExists(Outputfile) Then
	Set objFile = objFSO.OpenTextFile(Outputfile, ForAppending) 	
	objFile.Write strOutput
	objFile.WriteBlankLines(1)
	objExplorer.Document.Body.InnerHTML = "Script progress: <br>" & strOutput
Else	
	' file not found
	'Wscript.echo "Error file not found.  Please run the script again."
End If

objFile.Close
End Function

'---------------------------------------------------------------------------------------
'Function: WriteToggleEnd
'Last Modified: 9/27/05 .csm
'This function writes the closing tags necessary for a collapsible html area.
'---------------------------------------------------------------------------------------
Function WriteToggleEnd

strReportFile.WriteLine("</div>")
strReportFile.WriteLine("</div>")

End Function

'---------------------------------------------------------------------------------------
'Function: WriteToggleStart
'Last Modified: 9/27/05 .csm
'This function writes the opening tags necessary for a collapsible html area.
'---------------------------------------------------------------------------------------
Function WriteToggleStart
Dim arrSectionHeader
strSourceLine = Replace(strSourceLine, "****Begin:", "")
strReportFile.WriteLine("<div onClick="&Chr(34)&"toggle('" &_
	Trim(strSourceLine) & "', event)"&Chr(34)&">")
strReportFile.Writeline("<b> + " & strSourceLine & "</b>")
strReportFile.WriteLine("</div>")
strReportFile.WriteLine("<div id="& Chr(34) & Trim(strSourceLine) &_
	Chr(34) & " style=" & Chr(34) & "display:none;" & Chr(34) & ">")
strReportFIle.Writeline("<div onClick="&Chr(34)&"toggle('"&Trim(strSourceLine)& _
	"', event)" & Chr(34) & ">")
End Function


'---------------------------------------------------------------------------------------
'Class CliWrapper captures output from a command line
'---------------------------------------------------------------------------------------
Class CliWrapper
	public stdout, stderr, command
	private sh, fso, syncmode, outfile, errfile
	private ForReading, TristateUseDefault, DoNotCreateFile
	
	Public Function Exec(sCmd)

		stdout = vbNullString: stderr = vbNullString
		command = sh.ExpandEnvironmentStrings(sCmd)
		sh.Run "%COMSPEC% /c " & sCmd & " 2>" & errfile _
			& " 1>" & outfile, 0, syncmode
		stderr = ProcessFile(errfile)
		stdout = ProcessFile(outfile)
		Exec = stdout
	End Function
	
	Private Sub class_initialize
		Set sh = CreateObject("WScript.Shell")
		Set fso = CreateObject("Scripting.FileSystemObject")
		ForReading = 1:	TristateUseDefault = -2
		DoNotCreateFile = false
		outfile = fso.GetTempName
		errfile = fso.GetTempName
		syncmode = true
	End Sub

	Private Function ProcessFile(filepath)
		If fso.FileExists(filepath) Then
			With fso.OpenTextFile(filepath, ForReading, _
				false, TristateUseDefault)
				If .AtEndOfStream <> true Then
					ProcessFile = .ReadAll
				End If
				.Close
				fso.DeleteFile(filepath)
			End With
		End If	
	End Function
End Class


'****************END FOOTER SECTION****************************************************		
'**************************************************************************************